<style>
  /* Modern Footer Design */
  .footer-modern {
    background: #1a1a1a;
    color: white;
    padding: 80px 0 40px 0;
    position: relative;
    overflow: hidden;
  }

  .footer-modern::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 1px;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
  }

  .footer-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
  }

  .footer-header {
    text-align: center;
    margin-bottom: 60px;
  }

  .footer-brand {
    font-family: 'Playfair Display', serif;
    font-size: 3rem;
    font-weight: 700;
    color: white;
    margin-bottom: 20px;
    letter-spacing: -1px;
  }

  .footer-tagline {
    font-size: 1.1rem;
    color: rgba(255, 255, 255, 0.7);
    font-weight: 400;
    max-width: 500px;
    margin: 0 auto;
    line-height: 1.6;
  }

  .footer-content {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 60px;
    margin-bottom: 60px;
  }

  .footer-section {
    text-align: center;
  }

  .footer-section h3 {
    font-family: 'Playfair Display', serif;
    font-size: 1.5rem;
    font-weight: 600;
    color: white;
    margin-bottom: 25px;
    position: relative;
  }

  .footer-section h3::after {
    content: '';
    position: absolute;
    bottom: -8px;
    left: 50%;
    transform: translateX(-50%);
    width: 40px;
    height: 2px;
    background: white;
  }

  .footer-section p {
    color: rgba(255, 255, 255, 0.7);
    line-height: 1.8;
    font-size: 1rem;
    margin-bottom: 0;
  }

  .footer-social {
    display: flex;
    justify-content: center;
    gap: 25px;
    margin-top: 25px;
  }

  .social-link {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 50px;
    height: 50px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
    color: white;
    font-size: 1.3rem;
    text-decoration: none;
    transition: all 0.3s ease;
    border: 1px solid rgba(255, 255, 255, 0.2);
  }

  .social-link:hover {
    background: white;
    color: #1a1a1a;
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
  }

  .footer-divider {
    height: 1px;
    background: rgba(255, 255, 255, 0.1);
    margin: 40px 0;
  }

  .footer-bottom {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 30px;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
  }

  .footer-copyright {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.95rem;
  }

  .footer-links {
    display: flex;
    gap: 30px;
  }

  .footer-links a {
    color: rgba(255, 255, 255, 0.6);
    text-decoration: none;
    font-size: 0.95rem;
    transition: color 0.3s ease;
  }

  .footer-links a:hover {
    color: white;
  }

  /* Responsive Design */
  @media (max-width: 768px) {
    .footer-modern {
      padding: 60px 0 30px 0;
    }

    .footer-brand {
      font-size: 2.5rem;
    }

    .footer-content {
      grid-template-columns: 1fr;
      gap: 40px;
    }

    .footer-bottom {
      flex-direction: column;
      gap: 20px;
      text-align: center;
    }

    .footer-links {
      justify-content: center;
    }
  }

  @media (max-width: 480px) {
    .footer-brand {
      font-size: 2rem;
    }

    .footer-tagline {
      font-size: 1rem;
    }

    .social-link {
      width: 45px;
      height: 45px;
      font-size: 1.2rem;
    }
  }
</style>

<footer class="footer-modern">
  <div class="footer-container">
    <!-- Footer Header -->
    <div class="footer-header">
      <div class="footer-brand">vedge</div>
      <p class="footer-tagline">Fashion minimalis untuk keseharianmu. Est. 2022 | Made for Everyday Style</p>
    </div>

    <!-- Footer Content -->
    <div class="footer-content">
      <div class="footer-section">
        <h3>Tentang Kami</h3>
        <p>vedge adalah brand fashion minimalis yang mengedepankan kenyamanan, gaya sederhana, dan cocok digunakan untuk aktivitas sehari-hari. Kami percaya bahwa tampil simpel tetap bisa membuatmu percaya diri dan standout dalam setiap momen.</p>
      </div>

      <div class="footer-section">
        <h3>Kontak</h3>
        <p>Hubungi kami untuk pertanyaan, saran, atau kerjasama. Kami siap membantu Anda menemukan gaya yang tepat untuk setiap kesempatan.</p>
        <div class="footer-social">
          <a href="https://www.instagram.com" class="social-link" target="_blank">
            <i class="fab fa-instagram"></i>
          </a>
          <a href="https://www.tiktok.com" class="social-link" target="_blank">
            <i class="fab fa-tiktok"></i>
          </a>
          <a href="#" class="social-link">
            <i class="fab fa-facebook"></i>
          </a>
        </div>
      </div>

      <div class="footer-section">
        <h3>Layanan</h3>
        <p>Kami menyediakan berbagai pilihan fashion berkualitas dengan desain minimalis yang timeless. Setiap produk dirancang dengan teliti untuk memberikan kenyamanan maksimal dalam beraktivitas sehari-hari.</p>
      </div>
    </div>

    <!-- Footer Bottom -->
    <div class="footer-bottom">
      <div class="footer-copyright">
        &copy; <?= date("Y") ?> vedge. All rights reserved.
      </div>
      <div class="footer-links">
        <a href="#">Privacy Policy</a>
        <a href="#">Terms of Service</a>
        <a href="#">Shipping Info</a>
      </div>
    </div>
  </div>

  <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</footer>
