<?php
require 'config.php';
require '../vedge/pelanggan/navbar.php';

// Ambil semua kategori untuk dropdown filter
$kategori_result = mysqli_query($conn, "SELECT * FROM kategori_produk");

// Cek apakah ada filter kategori
$filter_kategori = isset($_GET['kategori']) ? (int)$_GET['kategori'] : 0;

$query = "SELECT produk.*, kategori_produk.nama AS nama_kategori 
          FROM produk 
          JOIN kategori_produk ON produk.kategori_id = kategori_produk.id";

if ($filter_kategori > 0) {
  $query .= " WHERE kategori_id = $filter_kategori";
}

$result = mysqli_query($conn, $query);

// Ambil data diskon untuk semua produk sekaligus (optimasi query)
$diskon_map = [];
$diskon_result = mysqli_query($conn, "SELECT * FROM diskon WHERE aktif = 'ya'");
while ($d = mysqli_fetch_assoc($diskon_result)) {
  $diskon_map[$d['id']] = $d;
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>vedge - Fashion Forward Collection</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
</head>

<body class="bg-white">
  <!-- Marquee Section -->
  <section class="marquee-section">
    <div class="marquee-container">
      <div class="marquee-content">
        <span class="marquee-text">Online Fashion Nomer 1 di Konoha, Dijamin Original dan Trusted</span>
        <span class="marquee-text">Online Fashion Nomer 1 di Konoha, Dijamin Original dan Trusted</span>
        <span class="marquee-text">Online Fashion Nomer 1 di Konoha, Dijamin Original dan Trusted</span>
        <span class="marquee-text">Online Fashion Nomer 1 di Konoha, Dijamin Original dan Trusted</span>
      </div>
          </div>
  </section>

  <!-- Modern Hero Section -->
  <section class="hero-section">
    <div class="hero-slider">
      <div class="hero-slide active" style="background-image: url('/vedge/assets/vedge1.png')">
        </div>

      <div class="hero-slide" style="background-image: url('/vedge/assets/vedge2.png')">
        </div>

      <div class="hero-slide" style="background-image: url('/vedge/assets/vedge3.png')">
        </div>

      <div class="hero-controls">
        <button class="hero-control prev" onclick="changeSlide(-1)">
          <i class="fas fa-chevron-left"></i>
      </button>
        <button class="hero-control next" onclick="changeSlide(1)">
          <i class="fas fa-chevron-right"></i>
      </button>
      </div>
      
      <div class="hero-indicators">
        <span class="indicator active" onclick="currentSlide(1)"></span>
        <span class="indicator" onclick="currentSlide(2)"></span>
        <span class="indicator" onclick="currentSlide(3)"></span>
      </div>
    </div>
  </section>

  <!-- Category Filter Section -->
  <section class="filter-section">
    <div class="container">
      <div class="filter-wrapper">
        <div class="filter-header">
          <h2 class="section-title">Our Collection</h2>
          <p class="section-subtitle">Find your perfect style from our curated selection</p>
      </div>

        <div class="filter-controls">
          <div class="filter-buttons">
            <a href="?" class="filter-btn <?= ($filter_kategori == 0) ? 'active' : '' ?>">
              All Categories
            </a>
                <?php
            mysqli_data_seek($kategori_result, 0);
                while ($kategori = mysqli_fetch_assoc($kategori_result)) :
                ?>
              <a href="?kategori=<?= $kategori['id'] ?>" class="filter-btn <?= ($filter_kategori == $kategori['id']) ? 'active' : '' ?>">
                    <?= htmlspecialchars($kategori['nama']) ?>
              </a>
                <?php endwhile; ?>
            </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Products Grid Section -->
  <section id="products" class="products-section">
    <div class="container">
      <div class="products-grid" id="product-grid">
        <?php if (mysqli_num_rows($result) > 0): ?>
          <?php while ($row = mysqli_fetch_assoc($result)) : ?>
            <div class="product-card">
              <div class="product-image-wrapper">
                  <img src="upload/<?= htmlspecialchars($row['gambar']) ?>"
                     class="product-image"
                     alt="<?= htmlspecialchars($row['nama']) ?>"
                     loading="lazy">
                
                  <div class="product-overlay">
                    <div class="product-actions">
                    <a href="detail_produk.php?id=<?= $row['id'] ?>" class="action-btn view-btn">
                      <i class="fas fa-eye"></i>
                      <span>View Details</span>
                      </a>
                    </div>
                  </div>
                
                <?php if (!empty($row['diskon_id']) && isset($diskon_map[$row['diskon_id']])): ?>
                  <div class="discount-badge">
                    -<?= $diskon_map[$row['diskon_id']]['persen'] ?>%
                  </div>
                <?php endif; ?>
                </div>

              <div class="product-info">
                <div class="product-category">
                      <?= htmlspecialchars($row['nama_kategori']) ?>
                  </div>

                <h3 class="product-title">
                    <?= htmlspecialchars($row['nama']) ?>
                </h3>
                
                <div class="product-price">
                  <?php if (!empty($row['diskon_id']) && isset($diskon_map[$row['diskon_id']])):
                    $diskon = $diskon_map[$row['diskon_id']];
                    $harga_diskon = $row['harga'] - ($row['harga'] * $diskon['persen'] / 100);
                  ?>
                    <span class="price-original">Rp<?= number_format($row['harga'], 0, ',', '.') ?></span>
                    <span class="price-current">Rp<?= number_format($harga_diskon, 0, ',', '.') ?></span>
                  <?php else: ?>
                    <span class="price-current">Rp<?= number_format($row['harga'], 0, ',', '.') ?></span>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endwhile; ?>
        <?php else: ?>
          <div class="empty-state">
            <div class="empty-icon">
              <i class="fas fa-search"></i>
            </div>
            <h3>No Products Found</h3>
            <p>Sorry, no products match your selected category.</p>
              <a href="?" class="btn btn-primary">
              <i class="fas fa-refresh me-2"></i>
              View All Products
              </a>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </section>

  <!-- Running Text Section -->
  <section class="running-text-section">
    <div class="running-text-container">
      <div class="running-text-content">
        <span class="running-text">vedge</span>
        <span class="running-text">vedge</span>
        <span class="running-text">vedge</span>
        <span class="running-text">vedge</span>
        <span class="running-text">vedge</span>
        <span class="running-text">vedge</span>
        <span class="running-text">vedge</span>
        <span class="running-text">vedge</span>
      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Modern Styles -->
  <style>
    /* Global Styles */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Playfair Display', serif;
      line-height: 1.6;
      color: #1a1a1a;
      background-color: #ffffff;
    }

    .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 0 20px;
    }

    /* Marquee Section */
    .marquee-section {
      background: white;
      padding: 12px 0;
      overflow: hidden;
      position: relative;
      border-bottom: 1px solid rgba(255, 255, 255, 0.98);
    }

    .marquee-container {
      width: 100%;
      overflow: hidden;
    }

    .marquee-content {
      display: flex;
      animation: marquee 20s linear infinite;
      white-space: nowrap;
    }

    .marquee-text {
      color: #1a1a1a;
      font-weight: 600;
      font-size: 1rem;
      padding: 0 30px;
      text-transform: uppercase;
      letter-spacing: 1px;
      display: flex;
      align-items: center;
    }

    .marquee-text::before {
      content: '🔥';
      margin-right: 10px;
      font-size: 1.2rem;
    }

    .marquee-text::after {
      content: '🔥';
      margin-left: 10px;
      font-size: 1.2rem;
    }

    @keyframes marquee {
      0% {
        transform: translateX(100%);
      }
      100% {
        transform: translateX(-100%);
      }
    }

    /* Pause marquee on hover */
    .marquee-container:hover .marquee-content {
      animation-play-state: paused;
    }

    /* Hero Section */
    .hero-section {
      position: relative;
      height: 80vh;
      min-height: 600px;
      overflow: hidden;
    }

    @media (max-width: 768px) {
      .hero-section {
        height: 40vh;      /* Lebih kecil di HP */
        min-height: 200px; /* Minimal tinggi di HP */
      }
    }
    @media (max-width: 480px) {
      .hero-section {
        height: 30vh;
        min-height: 120px;
      }
    }

    .hero-slider {
      position: relative;
      width: 100%;
      height: 100%;
    }

    .hero-slide {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-size: cover;
      background-position: center;
      background-repeat: no-repeat;
      display: flex;
      align-items: center;
      opacity: 0;
      transition: opacity 0.8s ease-in-out;
    }

    @media (max-width: 768px) {
      .hero-slide {
        background-position: top center;
      }
    }

    .hero-slide.active {
      opacity: 1;
    }

    .hero-content {
      color: white;
      max-width: 600px;
      z-index: 2;
    }

    .hero-title {
      font-size: 3.5rem;
      font-weight: 800;
      margin-bottom: 1rem;
      line-height: 1.2;
      text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
    }

    .hero-subtitle {
      font-size: 1.25rem;
      margin-bottom: 2rem;
      opacity: 0.9;
      text-shadow: 1px 1px 2px rgba(0,0,0,0.3);
    }

    .hero-cta {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      border: none;
      padding: 15px 30px;
      border-radius: 50px;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      transition: all 0.3s ease;
      box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
    }

    .hero-cta:hover {
      transform: translateY(-2px);
      box-shadow: 0 15px 40px rgba(102, 126, 234, 0.4);
    }

    .hero-controls {
      position: absolute;
      top: 50%;
      transform: translateY(-50%);
      width: 100%;
      display: flex;
      justify-content: space-between;
      padding: 0 30px;
      z-index: 3;
    }

    .hero-control {
      background: rgba(255, 255, 255, 0.2);
      border: none;
      color: white;
      width: 50px;
      height: 50px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      transition: all 0.3s ease;
      backdrop-filter: blur(10px);
    }

    .hero-control:hover {
      background: rgba(255, 255, 255, 0.3);
      transform: scale(1.1);
    }

    .hero-indicators {
      position: absolute;
      bottom: 30px;
      left: 50%;
      transform: translateX(-50%);
      display: flex;
      gap: 10px;
      z-index: 3;
    }

    .indicator {
      width: 12px;
      height: 12px;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.5);
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .indicator.active {
      background: white;
      transform: scale(1.2);
    }

    /* Filter Section */
    .filter-section {
      padding: 60px 0;
      background: #f8f9fa;
    }

    .filter-wrapper {
      text-align: center;
    }

    .filter-header {
      margin-bottom: 40px;
    }

    .section-title {
      font-size: 2.5rem;
      font-weight: 700;
      margin-bottom: 1rem;
      color: #1a1a1a;
    }

    .section-subtitle {
      font-size: 1.1rem;
      color: #666;
      max-width: 500px;
      margin: 0 auto;
    }

    .filter-controls {
      display: flex;
      justify-content: center;
    }

    .filter-buttons {
      display: flex;
      flex-wrap: wrap;
      gap: 12px;
      justify-content: center;
      max-width: 800px;
    }

    .filter-btn {
      padding: 12px 24px;
      border: 2px solid #000000;
      border-radius: 25px;
      background: white;
      color: #000000;
      text-decoration: none;
      font-weight: 600;
      font-size: 0.95rem;
      transition: all 0.3s ease;
      cursor: pointer;
      white-space: nowrap;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .filter-btn:hover {
      border-color: #000000;
      background: #000000;
      color: white;
      transform: translateY(-3px);
      box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
    }

    .filter-btn.active {
      border-color: #000000;
      background: #000000;
      color: white;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
    }

    /* Products Section */
    .products-section {
      padding: 80px 0;
    }

    .products-grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
      gap: 30px;
      margin-top: 40px;
    }

    .product-card {
      background: white;
      border-radius: 16px;
      overflow: hidden;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
      transition: all 0.3s ease;
      cursor: pointer;
    }

    .product-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }

    .product-image-wrapper {
      position: relative;
      height: 320px;
      overflow: hidden;
      background: #f8f9fa;
    }

    .product-image {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transition: transform 0.3s ease;
    }

    .product-card:hover .product-image {
      transform: scale(1.05);
    }

    .product-overlay {
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(0, 0, 0, 0.7);
      display: flex;
      align-items: center;
      justify-content: center;
      opacity: 0;
      transition: all 0.3s ease;
    }

    .product-card:hover .product-overlay {
      opacity: 1;
    }

    .product-actions {
      display: flex;
      flex-direction: column;
      gap: 12px;
      align-items: center;
    }

    .action-btn {
      background: white;
      border: none;
      padding: 12px 24px;
      border-radius: 25px;
      color: #1a1a1a;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: 8px;
      cursor: pointer;
      transition: all 0.3s ease;
      text-decoration: none;
      font-size: 0.9rem;
    }

    .action-btn:hover {
      background: #667eea;
      color: white;
      transform: translateY(-2px);
    }

    .discount-badge {
      position: absolute;
      top: 15px;
      right: 15px;
      background: linear-gradient(135deg, #ff6b6b, #ee5a24);
      color: white;
      padding: 6px 12px;
      border-radius: 20px;
      font-weight: 700;
      font-size: 0.85rem;
    }

    .product-info {
      padding: 20px;
    }

    .product-category {
      font-size: 0.85rem;
      color: #667eea;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      margin-bottom: 8px;
    }

    .product-title {
      font-size: 1.1rem;
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 12px;
      line-height: 1.4;
    }

    .product-price {
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .price-original {
      font-size: 0.9rem;
      color: #999;
      text-decoration: line-through;
    }

    .price-current {
      font-size: 1.2rem;
      font-weight: 700;
      color: #1a1a1a;
    }

    /* Empty State */
    .empty-state {
      grid-column: 1 / -1;
      text-align: center;
      padding: 80px 20px;
    }

    .empty-icon {
      font-size: 4rem;
      color: #ccc;
      margin-bottom: 20px;
    }

    .empty-state h3 {
      font-size: 1.5rem;
      margin-bottom: 10px;
      color: #666;
    }

    .empty-state p {
      color: #999;
      margin-bottom: 30px;
    }

    /* Running Text Section */
    .running-text-section {
      background: #1a1a1a;
      padding: 40px 0;
      overflow: hidden;
      position: relative;
    }

    .running-text-container {
      width: 100%;
      overflow: hidden;
    }

    .running-text-content {
      display: flex;
      animation: runningText 15s linear infinite;
      white-space: nowrap;
    }

    .running-text {
      color: white;
      font-family: 'Playfair Display', serif;
      font-weight: 700;
      font-size: 4.5rem;
      padding: 0 40px;
      text-transform: lowercase;
      letter-spacing: 2px;
      display: flex;
      align-items: center;
    }

    .running-text::before {
      content: '';
      margin-right: 20px;
      font-size: 1.5rem;
      color: #667eea;
    }

    .running-text::after {
      content: '';
      margin-left: 20px;
      font-size: 1.5rem;
      color: #667eea;
    }

    @keyframes runningText {
      0% {
        transform: translateX(100%);
      }
      100% {
        transform: translateX(-100%);
      }
    }

    /* Pause running text on hover */
    .running-text-container:hover .running-text-content {
      animation-play-state: paused;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .marquee-text {
        font-size: 0.9rem;
        padding: 0 20px;
      }

      .marquee-text::before,
      .marquee-text::after {
        font-size: 1rem;
      }

      .hero-section {
        height: 40vh;
        min-height: 200px;
      }
      .hero-slide {
        background-position: top center;
      }

      .section-title {
        font-size: 2rem;
      }

      .products-grid {
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 20px;
      }

      .product-image-wrapper {
        height: 250px;
      }

      .running-text {
        font-size: 2rem;
        padding: 0 30px;
      }

      .running-text::before,
      .running-text::after {
        font-size: 1.2rem;
        margin: 0 15px;
      }

      .filter-form {
        flex-direction: column;
        align-items: center;
      }

      .hero-controls {
        padding: 0 15px;
      }

      .hero-control {
        width: 40px;
        height: 40px;
      }

      .hero-slide:nth-child(1) {
        background-image: url('/vedge/assets/AA-mobile.png');
      }
      .hero-slide:nth-child(2) {
        background-image: url('/vedge/assets/BB-mobile.png');
      }
      .hero-slide:nth-child(3) {
        background-image: url('/vedge/assets/CC-mobile.png');
      }
    }

    @media (max-width: 480px) {
      .marquee-text {
        font-size: 0.8rem;
        padding: 0 15px;
      }

      .marquee-text::before,
      .marquee-text::after {
        font-size: 0.9rem;
        margin: 0 5px;
      }

      .hero-section {
        height: 30vh;
        min-height: 120px;
      }

      .hero-slide {
        background-size: cover;
        background-position: center;
      }

      .products-grid {
        grid-template-columns: 1fr;
        gap: 15px;
      }

      .product-image-wrapper {
        height: 200px;
      }

      .container {
        padding: 0 15px;
      }

      .hero-indicators {
        bottom: 20px;
      }

      .indicator {
        width: 10px;
        height: 10px;
      }
    }

    /* Animation Classes */
    .fade-in {
      opacity: 0;
      transform: translateY(30px);
      animation: fadeInUp 0.8s ease forwards;
    }

    @keyframes fadeInUp {
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .stagger-animation {
      animation-delay: calc(var(--stagger-index) * 0.1s);
    }
  </style>

  <!-- JavaScript -->
  <script>
    // Hero Slider
    let currentSlideIndex = 0;
    const slides = document.querySelectorAll('.hero-slide');
    const indicators = document.querySelectorAll('.indicator');
    const totalSlides = slides.length;

    function showSlide(index) {
      slides.forEach(slide => slide.classList.remove('active'));
      indicators.forEach(indicator => indicator.classList.remove('active'));
      
      slides[index].classList.add('active');
      indicators[index].classList.add('active');
    }

    function changeSlide(direction) {
      currentSlideIndex = (currentSlideIndex + direction + totalSlides) % totalSlides;
      showSlide(currentSlideIndex);
    }

    function currentSlide(index) {
      currentSlideIndex = index - 1;
      showSlide(currentSlideIndex);
    }

    // Auto slide
    setInterval(() => {
      changeSlide(1);
    }, 5000);

    // Wishlist functionality
    function toggleWishlist(button) {
      button.classList.toggle('active');
      const icon = button.querySelector('i');
      const text = button.querySelector('span');
      
      if (button.classList.contains('active')) {
        icon.style.color = '#ff6b6b';
        text.textContent = 'Added to Wishlist';
        showNotification('Added to wishlist!', 'success');
      } else {
        icon.style.color = '';
        text.textContent = 'Add to Wishlist';
        showNotification('Removed from wishlist!', 'info');
      }
    }

    // Notification system
    function showNotification(message, type = 'success') {
      const notification = document.createElement('div');
      notification.className = `notification notification-${type}`;
      notification.textContent = message;
      
      notification.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        background: ${type === 'success' ? '#4CAF50' : '#2196F3'};
        color: white;
        padding: 15px 25px;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        z-index: 1000;
        transform: translateX(100%);
        transition: transform 0.3s ease;
      `;

      document.body.appendChild(notification);

      setTimeout(() => {
        notification.style.transform = 'translateX(0)';
      }, 100);

      setTimeout(() => {
        notification.style.transform = 'translateX(100%)';
        setTimeout(() => notification.remove(), 300);
      }, 3000);
    }

    // Intersection Observer for animations
    const observerOptions = {
      threshold: 0.1,
      rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
      entries.forEach((entry, index) => {
        if (entry.isIntersecting) {
          entry.target.style.setProperty('--stagger-index', index);
          entry.target.classList.add('fade-in', 'stagger-animation');
        }
      });
    }, observerOptions);

    // Observe product cards
    document.querySelectorAll('.product-card').forEach(card => {
      observer.observe(card);
    });

    // Smooth scroll
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
      anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
          target.scrollIntoView({
            behavior: 'smooth',
            block: 'start'
          });
        }
      });
    });

    // Form handling
    document.getElementById('filterForm').addEventListener('submit', function() {
      const select = this.querySelector('select');
      select.disabled = true;
      
      // Add loading state
      const originalText = select.innerHTML;
      select.innerHTML = '<option>Loading...</option>';
      
      // Re-enable after a short delay
      setTimeout(() => {
        select.disabled = false;
        select.innerHTML = originalText;
      }, 1000);
    });



    // Initialize tooltips
    document.addEventListener('DOMContentLoaded', function() {
      // Add any additional initialization here
  });
  </script>

  <?php include 'footer.php'; ?>
</body>

</html>