<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login - vedge</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Playfair Display', serif;
      background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
      min-height: 100vh;
      color: #1a1a1a;
      line-height: 1.6;
    }

    .login-container {
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 2rem 1rem;
    }

    .login-card {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(20px);
      border-radius: 24px;
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
      border: 1px solid rgba(255, 255, 255, 0.2);
      max-width: 450px;
      width: 100%;
      overflow: hidden;
      transition: all 0.3s ease;
    }

    .login-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 30px 80px rgba(0, 0, 0, 0.15);
    }

    .brand-header {
      background: linear-gradient(135deg, #1a1a1a 0%, #333333 100%);
      color: white;
      padding: 2.5rem 2rem;
      text-align: center;
      position: relative;
      overflow: hidden;
    }

    .brand-header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/><circle cx="10" cy="60" r="0.5" fill="white" opacity="0.1"/><circle cx="90" cy="40" r="0.5" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
      opacity: 0.3;
    }

    .brand-title {
      font-size: 2.5rem;
      font-weight: 800;
      margin-bottom: 0.5rem;
      position: relative;
      z-index: 1;
      letter-spacing: -0.02em;
    }

    .brand-subtitle {
      font-size: 1rem;
      font-weight: 400;
      opacity: 0.9;
      position: relative;
      z-index: 1;
      font-style: italic;
    }

    .login-body {
      padding: 2.5rem 2rem;
    }

    .welcome-text {
      text-align: center;
      margin-bottom: 2rem;
    }

    .welcome-title {
      font-size: 1.5rem;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 0.5rem;
    }

    .welcome-subtitle {
      color: #666;
      font-size: 0.95rem;
    }

    .alert {
      border-radius: 12px;
      padding: 1rem 1.5rem;
      margin-bottom: 1.5rem;
      border: none;
      font-weight: 500;
    }

    .alert-danger {
      background: linear-gradient(135deg, #fee 0%, #fcc 100%);
      color: #c53030;
      border-left: 4px solid #c53030;
    }

    .alert-success {
      background: linear-gradient(135deg, #f0fff4 0%, #dcfce7 100%);
      color: #059669;
      border-left: 4px solid #059669;
    }

    .alert-info {
      background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);
      color: #1d4ed8;
      border-left: 4px solid #1d4ed8;
    }

    .form-group {
      margin-bottom: 1.5rem;
    }

    .form-label {
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 0.75rem;
      font-size: 0.95rem;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .input-wrapper {
      position: relative;
      display: flex;
      align-items: center;
      background: white;
      border: 2px solid #e9ecef;
      border-radius: 12px;
      transition: all 0.3s ease;
      overflow: hidden;
    }

    .input-wrapper:focus-within {
      border-color: #1a1a1a;
      box-shadow: 0 0 0 3px rgba(26, 26, 26, 0.1);
    }

    .input-icon {
      padding: 1rem;
      color: #666;
      font-size: 1.1rem;
      background: #f8f9fa;
      border-right: 1px solid #e9ecef;
    }

    .form-control {
      border: none;
      padding: 1rem 1.5rem;
      font-size: 1rem;
      background: transparent;
      color: #1a1a1a;
      font-family: 'Playfair Display', serif;
      flex: 1;
    }

    .form-control:focus {
      outline: none;
      box-shadow: none;
    }

    .form-control::placeholder {
      color: #999;
      font-style: italic;
    }

    .password-toggle {
      padding: 1rem;
      background: transparent;
      border: none;
      color: #666;
      cursor: pointer;
      transition: color 0.3s ease;
    }

    .password-toggle:hover {
      color: #1a1a1a;
    }

    .btn-login {
      background: linear-gradient(135deg, #1a1a1a 0%, #333333 100%);
      color: white;
      border: none;
      border-radius: 12px;
      padding: 1rem 2rem;
      font-size: 1.1rem;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      transition: all 0.3s ease;
      width: 100%;
      margin-bottom: 1.5rem;
    }

    .btn-login:hover {
      background: linear-gradient(135deg, #000000 0%, #1a1a1a 100%);
      transform: translateY(-2px);
      box-shadow: 0 10px 30px rgba(26, 26, 26, 0.3);
      color: white;
    }

    .divider {
      text-align: center;
      margin: 1.5rem 0;
      position: relative;
    }

    .divider::before {
      content: '';
      position: absolute;
      top: 50%;
      left: 0;
      right: 0;
      height: 1px;
      background: #e9ecef;
    }

    .divider-text {
      background: rgba(255, 255, 255, 0.95);
      padding: 0 1rem;
      color: #666;
      font-size: 0.9rem;
      font-style: italic;
    }

    .action-links {
      text-align: center;
    }

    .action-link {
      display: block;
      color: #1a1a1a;
      text-decoration: none;
      font-weight: 500;
      margin-bottom: 0.75rem;
      transition: color 0.3s ease;
    }

    .action-link:hover {
      color: #000;
    }

    .action-link.primary {
      color: #1a1a1a;
      font-weight: 600;
    }

    .action-link.secondary {
      color: #666;
      font-size: 0.9rem;
      font-style: italic;
    }

    .footer {
      text-align: center;
      margin-top: 2rem;
      padding-top: 1.5rem;
      border-top: 1px solid #e9ecef;
    }

    .footer-text {
      color: #666;
      font-size: 0.85rem;
      font-style: italic;
    }

    .fade-in {
      animation: fadeIn 0.8s ease-out;
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    @media (max-width: 768px) {
      .login-container {
        padding: 1rem;
      }

      .brand-title {
        font-size: 2rem;
      }

      .login-body {
        padding: 2rem 1.5rem;
      }

      .welcome-title {
        font-size: 1.25rem;
      }
    }

    @media (max-width: 480px) {
      .brand-header {
        padding: 2rem 1.5rem;
      }

      .brand-title {
        font-size: 1.75rem;
      }

      .login-body {
        padding: 1.5rem 1rem;
      }
    }
  </style>
</head>
<body>
  <div class="login-container">
    <div class="login-card fade-in">
      <!-- Brand Header -->
      <div class="brand-header">
        <h1 class="brand-title">vedge</h1>
        <p class="brand-subtitle">Fashion Forward Collection</p>
      </div>

      <!-- Login Body -->
      <div class="login-body">
        <!-- Welcome Text -->
        <div class="welcome-text">
          <h2 class="welcome-title">Welcome Back</h2>
          <p class="welcome-subtitle">Sign in to your account to continue</p>
        </div>

        <!-- Alert Messages -->
        <div id="alert-container">
          <?php
          if (isset($_GET['pesan'])) {
            if ($_GET['pesan'] == 'gagal') {
              echo '<div class="alert alert-danger" role="alert">
                      <i class="fas fa-exclamation-circle me-2"></i>Email atau password salah!
                    </div>';
            } elseif ($_GET['pesan'] == 'daftar_sukses') {
              echo '<div class="alert alert-success" role="alert">
                      <i class="fas fa-check-circle me-2"></i>Berhasil daftar! Silakan login.
                    </div>';
            } elseif ($_GET['pesan'] == 'logout') {
              echo '<div class="alert alert-info" role="alert">
                      <i class="fas fa-info-circle me-2"></i>Anda telah logout.
                    </div>';
            }
          }
          ?>
        </div>

        <!-- Login Form -->
        <form action="../vedge/proses/proses_pelanggan_login.php" method="POST">
          <!-- Email Input -->
          <div class="form-group">
            <label for="email" class="form-label">Email Address</label>
            <div class="input-wrapper">
              <div class="input-icon">
                <i class="fas fa-envelope"></i>
              </div>
              <input type="email" 
                     name="email" 
                     id="email"
                     class="form-control" 
                     placeholder="Enter your email address"
                     required>
            </div>
          </div>

          <!-- Password Input -->
          <div class="form-group">
            <label for="password" class="form-label">Password</label>
            <div class="input-wrapper">
              <div class="input-icon">
                <i class="fas fa-lock"></i>
              </div>
              <input type="password" 
                     name="password" 
                     id="password"
                     class="form-control" 
                     placeholder="Enter your password"
                     required>
              <button class="password-toggle" 
                      type="button" 
                      id="togglePassword">
                <i class="fas fa-eye" id="eyeIcon"></i>
              </button>
            </div>
          </div>

          <!-- Login Button -->
          <button type="submit" class="btn btn-login">
            <i class="fas fa-sign-in-alt me-2"></i>Sign In
          </button>
        </form>

        <!-- Divider -->
        <div class="divider">
          <span class="divider-text">or</span>
        </div>

        <!-- Action Links -->
        <div class="action-links">
          <a href="../vedge/register.php" class="action-link primary">
            Don't have an account? <strong>Sign up here</strong>
          </a>
          <a href="../vedge/lupa_password.php" class="action-link secondary">
            <i class="fas fa-question-circle me-1"></i>Forgot your password?
          </a>
        </div>

        <!-- Footer -->
        <div class="footer">
          <p class="footer-text">© 2025 vedge. All rights reserved.</p>
        </div>
      </div>
    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Toggle Password Visibility -->
  <script>
    document.getElementById('togglePassword').addEventListener('click', function () {
      const password = document.getElementById('password');
      const eyeIcon = document.getElementById('eyeIcon');
      
      if (password.type === 'password') {
        password.type = 'text';
        eyeIcon.classList.remove('fa-eye');
        eyeIcon.classList.add('fa-eye-slash');
      } else {
        password.type = 'password';
        eyeIcon.classList.remove('fa-eye-slash');
        eyeIcon.classList.add('fa-eye');
      }
    });
  </script>
</body>
</html>