<?php
require '../config.php';
require '../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

session_start();

if (!isset($_GET['id'])) {
  die("ID tidak ditemukan.");
}

$id = (int) $_GET['id'];

$transaksi = mysqli_fetch_assoc(mysqli_query($conn, "
  SELECT t.*, u.nama AS nama_pelanggan, u.alamat_lengkap, u.provinsi, u.kabupaten_kota, u.kecamatan, u.kelurahan 
  FROM transaksi t
  JOIN pengguna u ON t.pengguna_id = u.id 
  WHERE t.id = $id
"));

if (!$transaksi) {
  die("Transaksi tidak ditemukan.");
}

$items = mysqli_query($conn, "
    SELECT td.*, p.nama, p.harga, up.ukuran
    FROM transaksi_detail td
    JOIN produk p ON td.produk_id = p.id
    JOIN ukuran_produk up ON td.ukuran_id = up.id
    WHERE td.transaksi_id = $id
");

function formatKodeTransaksi($id, $timestamp) {
  $tanggal = date('Ymd', strtotime($timestamp));
  return 'TRX-' . $tanggal . '-' . str_pad($id, 4, '0', STR_PAD_LEFT);
}

$logoUrl = 'http://localhost/vedge/assets/vedge.png'; // Ganti dengan URL logo kamu

ob_start();
?>

<!DOCTYPE html>
<html>
<head>
  <style>
    body {
      font-family: 'Arial', sans-serif;
      font-size: 12px;
      margin: 30px;
      color: #333;
    }

    .brand-header {
      display: flex;
      align-items: center;
      gap: 10px;
      margin-bottom: 20px;
    }

    .brand-header img {
      height: 50px;
    }

    .brand-header .brand-name {
      font-size: 20px;
      font-weight: bold;
      letter-spacing: -0.5px;
      color: #111;
    }

    h2 {
      text-align: center;
      font-size: 18px;
      margin-bottom: 20px;
      border-bottom: 1px solid #ccc;
      padding-bottom: 10px;
    }

    .info p {
      margin: 4px 0;
      line-height: 1.4;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }

    th {
      background-color: #f5f5f5;
      font-weight: bold;
    }

    th, td {
      border: 1px solid #ddd;
      padding: 8px;
      text-align: left;
    }

    .summary {
      margin-top: 20px;
      text-align: right;
      font-size: 13px;
    }

    .summary p {
      margin: 3px 0;
    }

    .footer {
      text-align: center;
      margin-top: 30px;
      font-size: 11px;
      color: #888;
    }
  </style>
</head>
<body>

  <div class="brand-header">
    <img src="<?= $logoUrl ?>" alt="Logo">
  </div>

  <h2>Invoice Pembelian</h2>

  <div class="info">
    <p><strong>No. Transaksi:</strong> <?= formatKodeTransaksi($transaksi['id'], $transaksi['dibuat_pada']) ?></p>
    <p><strong>Nama:</strong> <?= htmlspecialchars($transaksi['nama_pelanggan']) ?></p>
    <p><strong>Alamat:</strong> <?= htmlspecialchars($transaksi['alamat_lengkap']) ?>, 
       <?= htmlspecialchars($transaksi['kelurahan']) ?>, 
       <?= htmlspecialchars($transaksi['kecamatan']) ?>, 
       <?= htmlspecialchars($transaksi['kabupaten_kota']) ?>, 
       <?= htmlspecialchars($transaksi['provinsi']) ?></p>
    <p><strong>Status:</strong> <?= $transaksi['status'] ?></p>
    <p><strong>Tanggal:</strong> <?= date('d M Y, H:i', strtotime($transaksi['dibuat_pada'])) ?></p>
  </div>

  <table>
    <thead>
      <tr>
        <th>Produk</th>
        <th>Ukuran</th>
        <th>Jumlah</th>
        <th>Subtotal</th>
      </tr>
    </thead>
    <tbody>
      <?php $total = 0; ?>
      <?php while ($item = mysqli_fetch_assoc($items)): ?>
        <tr>
          <td><?= htmlspecialchars($item['nama']) ?></td>
          <td><?= htmlspecialchars($item['ukuran']) ?></td>
          <td><?= $item['jumlah'] ?></td>
          <td>Rp <?= number_format($item['subtotal'], 0, ',', '.') ?></td>
        </tr>
        <?php $total += $item['subtotal']; ?>
      <?php endwhile; ?>
    </tbody>
  </table>

  <div class="summary">
    <p><strong>Ongkos Kirim:</strong> Rp <?= number_format($transaksi['ongkos_kirim'], 0, ',', '.') ?></p>
    <p><strong>Total Harga:</strong> Rp <?= number_format($transaksi['total_harga'], 0, ',', '.') ?></p>
  </div>

  <div class="footer">
    Terima kasih telah berbelanja di vedge
  </div>

</body>
</html>

<?php
$html = ob_get_clean();

$options = new Options();
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("invoice-transaksi-$id.pdf", ["Attachment" => false]);
exit;
