<?php
require '../config.php';
session_start();
require 'navbar.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$query = mysqli_query($conn, "SELECT * FROM pengguna WHERE id = $user_id");
$user = mysqli_fetch_assoc($query);

if ($user['peran'] !== 'pelanggan') {
    echo "Akses ditolak!";
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kontak - vedge</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color:rgb(223, 223, 223);
            --secondary-color: #f8f8f8;
            --accent-color: #d4af37;
            --text-dark: #2c2c2c;
            --text-light: #666666;
            --border-color: #e8e8e8;
            --shadow-light: 0 2px 20px rgba(0, 0, 0, 0.04);
            --shadow-medium: 0 8px 40px rgba(0, 0, 0, 0.08);
            --shadow-heavy: 0 20px 60px rgba(0, 0, 0, 0.12);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            color: var(--text-dark);
            line-height: 1.6;
            overflow-x: hidden;
        }

        .playfair {
            font-family: 'Playfair Display', serif;
        }

        /* Hero Section */
        .hero-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, #2c2c2c 100%);
            color: white;
            padding: 4rem 0;
            position: relative;
            overflow: hidden;
        }

        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="20" cy="20" r="1" fill="white" opacity="0.03"/><circle cx="80" cy="30" r="0.5" fill="white" opacity="0.05"/><circle cx="40" cy="70" r="1.5" fill="white" opacity="0.02"/><circle cx="90" cy="80" r="0.8" fill="white" opacity="0.04"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        }

        .hero-content {
            position: relative;
            z-index: 2;
            text-align: center;
        }

        .hero-title {
            font-size: 3.5rem;
            font-weight: 600;
            margin-bottom: 1rem;
            background: linear-gradient(135deg, white 0%, var(--accent-color) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .hero-subtitle {
            font-size: 1.2rem;
            opacity: 0.9;
            font-weight: 300;
            max-width: 600px;
            margin: 0 auto;
        }

        /* Main Container */
        .main-container {
            margin-top: -3rem;
            position: relative;
            z-index: 3;
        }

        .glass-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 24px;
            padding: 2.5rem;
            margin-bottom: 2rem;
            box-shadow: var(--shadow-medium);
            transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            position: relative;
            overflow: hidden;
        }

        .glass-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent 0%, var(--accent-color) 50%, transparent 100%);
        }

        .glass-card:hover {
            transform: translateY(-8px);
            box-shadow: var(--shadow-heavy);
            background: rgba(255, 255, 255, 0.98);
        }

        /* Contact Cards */
        .contact-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary-color) 0%, #3c3c3c 100%);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 2rem;
            margin: 0 auto 2rem auto;
            position: relative;
            overflow: hidden;
        }

        .contact-icon::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent 30%, rgba(212, 175, 55, 0.1) 50%, transparent 70%);
            transform: rotate(45deg);
            transition: all 0.6s ease;
        }

        .glass-card:hover .contact-icon::before {
            transform: rotate(45deg) translate(50%, 50%);
        }

        .card-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: var(--text-dark);
            margin-bottom: 1rem;
            text-align: center;
        }

        .card-description {
            color: var(--text-light);
            text-align: center;
            font-size: 1rem;
            line-height: 1.7;
            margin-bottom: 2rem;
        }

        /* WhatsApp Button */
        .whatsapp-container {
            text-align: center;
            margin-bottom: 2rem;
        }

        .whatsapp-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #25d366 0%, #128c7e 100%);
            color: white;
            text-decoration: none;
            padding: 1.2rem 2.5rem;
            border-radius: 16px;
            font-weight: 500;
            font-size: 1.1rem;
            box-shadow: 0 8px 32px rgba(37, 211, 102, 0.3);
            transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            position: relative;
            overflow: hidden;
        }

        .whatsapp-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent 0%, rgba(255, 255, 255, 0.2) 50%, transparent 100%);
            transition: left 0.5s ease;
        }

        .whatsapp-btn:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 48px rgba(37, 211, 102, 0.4);
            color: white;
            text-decoration: none;
        }

        .whatsapp-btn:hover::before {
            left: 100%;
        }

        .phone-number {
            font-weight: 600;
            letter-spacing: 1px;
            margin-left: 0.5rem;
        }

        /* Feature List */
        .feature-list {
            list-style: none;
            padding: 0;
        }

        .feature-item {
            display: flex;
            align-items: center;
            padding: 1rem 0;
            border-bottom: 1px solid var(--border-color);
            transition: all 0.3s ease;
        }

        .feature-item:last-child {
            border-bottom: none;
        }

        .feature-item:hover {
            transform: translateX(8px);
            color: var(--accent-color);
        }

        .feature-icon {
            color: var(--accent-color);
            margin-right: 1rem;
            width: 24px;
            font-size: 1.1rem;
        }

        /* Info Cards */
        .info-card {
            background: linear-gradient(135deg, var(--secondary-color) 0%, #ffffff 100%);
            border-radius: 16px;
            padding: 2rem;
            text-align: center;
            border: 1px solid var(--border-color);
        }

        .info-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: var(--text-dark);
            margin-bottom: 0.8rem;
        }

        .info-text {
            color: var(--text-light);
            font-size: 0.95rem;
            line-height: 1.6;
        }

        /* Map Section */
        .map-container {
            border-radius: 20px;
            overflow: hidden;
            box-shadow: var(--shadow-medium);
            height: 450px;
            margin: 2rem 0;
        }

        .map-container iframe {
            filter: grayscale(20%) contrast(1.1);
            transition: filter 0.3s ease;
        }

        .map-container:hover iframe {
            filter: grayscale(0%) contrast(1.2);
        }

        .transport-info {
            margin-top: 2rem;
        }

        .transport-item {
            background: rgba(255, 255, 255, 0.8);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 1rem;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .transport-item:hover {
            background: white;
            transform: translateY(-2px);
            box-shadow: var(--shadow-light);
        }

        .transport-icon {
            color: var(--accent-color);
            margin-right: 1rem;
            width: 24px;
            font-size: 1.2rem;
        }

        /* Toast Notification */
        .toast-notification {
            position: fixed;
            top: 2rem;
            right: 2rem;
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            padding: 1rem 1.5rem;
            border-radius: 12px;
            box-shadow: 0 8px 32px rgba(40, 167, 69, 0.3);
            transform: translateX(400px);
            transition: transform 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            z-index: 9999;
            backdrop-filter: blur(10px);
        }

        .toast-notification.show {
            transform: translateX(0);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
            }

            .hero-subtitle {
                font-size: 1rem;
            }

            .glass-card {
                padding: 2rem 1.5rem;
                border-radius: 20px;
            }

            .contact-icon {
                width: 60px;
                height: 60px;
                font-size: 1.5rem;
            }

            .card-title {
                font-size: 1.5rem;
            }

            .whatsapp-btn {
                padding: 1rem 2rem;
                font-size: 1rem;
            }

            .map-container {
                height: 300px;
            }

            .toast-notification {
                right: 1rem;
                left: 1rem;
                transform: translateY(-100px);
            }

            .toast-notification.show {
                transform: translateY(0);
            }
        }

        @media (max-width: 480px) {
            .hero-title {
                font-size: 2rem;
            }

            .glass-card {
                padding: 1.5rem 1rem;
            }

            .whatsapp-btn {
                padding: 0.8rem 1.5rem;
                font-size: 0.9rem;
            }
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-fade-in {
            animation: fadeInUp 0.6s ease-out forwards;
        }

        .animate-delay-1 { animation-delay: 0.1s; }
        .animate-delay-2 { animation-delay: 0.2s; }
        .animate-delay-3 { animation-delay: 0.3s; }
    </style>
</head>

<body>
    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="hero-content">
                <h1 class="hero-title playfair">Hubungi vedge</h1>
                <p class="hero-subtitle">Tim customer service premium kami siap memberikan layanan terbaik untuk Anda, kapan saja dan di mana saja</p>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <div class="container main-container">
        <div class="row">
            <!-- Main Contact Card -->
            <div class="col-lg-8 mb-4">
                <div class="glass-card animate-fade-in">
                    <div class="contact-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <h2 class="card-title playfair">Customer Service 24/7</h2>
                    <p class="card-description">
                        Rasakan pengalaman layanan pelanggan yang tak tertandingi. Tim profesional kami siap membantu dengan dedikasi penuh, memberikan solusi cepat dan tepat untuk setiap kebutuhan Anda.
                    </p>

                    <div class="whatsapp-container">
                        <a href="https://wa.me/6281383276822" target="_blank" class="whatsapp-btn">
                            <i class="fab fa-whatsapp"></i>
                            <span class="phone-number">081383276822</span>
                        </a>
                    </div>

                    <ul class="feature-list">
                        <li class="feature-item">
                            <i class="fas fa-clock feature-icon"></i>
                            <span>Layanan pelanggan 24 jam non-stop</span>
                        </li>
                        <li class="feature-item">
                            <i class="fas fa-shipping-fast feature-icon"></i>
                            <span>Tracking status pesanan real-time</span>
                        </li>
                        <li class="feature-item">
                            <i class="fas fa-credit-card feature-icon"></i>
                            <span>Bantuan pembayaran dan pengiriman</span>
                        </li>
                        <li class="feature-item">
                            <i class="fas fa-ruler feature-icon"></i>
                            <span>Konsultasi produk dan panduan ukuran</span>
                        </li>
                        <li class="feature-item">
                            <i class="fas fa-undo feature-icon"></i>
                            <span>Penanganan komplain dan proses retur</span>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Operating Hours -->
                <div class="glass-card animate-fade-in animate-delay-1 mb-4">
                    <div class="contact-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3 class="card-title playfair">Jam Operasional</h3>
                    <p class="card-description">Kami berkomitmen melayani Anda tanpa batas waktu</p>
                    <div class="info-card">
                        <h4 class="info-title playfair">24 Jam / 7 Hari</h4>
                        <p class="info-text">Senin - Minggu<br><strong>00:00 - 24:00 WIB</strong></p>
                    </div>
                </div>

                <!-- Store Location -->
                <div class="glass-card animate-fade-in animate-delay-2">
                    <div class="contact-icon">
                        <i class="fas fa-store"></i>
                    </div>
                    <h3 class="card-title playfair">Lokasi Toko</h3>
                    <p class="card-description">Kunjungi flagship store kami untuk pengalaman belanja yang tak terlupakan</p>
                    <div class="info-card">
                        <h4 class="info-title playfair">vedge Flagship Store</h4>
                        <p class="info-text">
                            Jl. Kusuma Timur III c no 32, Ampera<br>
                            Kota Bekasi, Jawa Barat 17111<br>
                            <strong>Indonesia</strong>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Map Section -->
        <div class="row">
            <div class="col-12">
                <div class="glass-card animate-fade-in animate-delay-3">
                    <div class="contact-icon">
                        <i class="fas fa-map-marked-alt"></i>
                    </div>
                    <h3 class="card-title playfair">Temukan Kami</h3>
                    <p class="card-description">Berlokasi strategis di jantung kota Bekasi, mudah dijangkau dengan berbagai moda transportasi</p>

                    <div class="map-container">
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d8904.871841873266!2d107.02258421252039!3d-6.241951433550057!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sid!2sid!4v1752834648205!5m2!1sid!2sid"
                            width="100%"
                            height="450"
                            style="border:0;"
                            allowfullscreen=""
                            loading="lazy"
                            referrerpolicy="no-referrer-when-downgrade">
                        </iframe>
                    </div>

                    <div class="transport-info">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="transport-item">
                                    <i class="fas fa-car transport-icon"></i>
                                    <div>
                                        <strong>Parkir Gratis</strong><br>
                                        <small>Area parkir luas tersedia</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="transport-item">
                                    <i class="fas fa-bus transport-icon"></i>
                                    <div>
                                        <strong>TransJakarta</strong><br>
                                        <small>Halte Bekasi Timur</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="transport-item">
                                    <i class="fas fa-train transport-icon"></i>
                                    <div>
                                        <strong>KRL Commuter</strong><br>
                                        <small>Stasiun Bekasi Timur</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include '../footer.php'; ?>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Copy to clipboard functionality
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                showToast('Nomor berhasil disalin ke clipboard!');
            }).catch(function(err) {
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = text;
                document.body.appendChild(textArea);
                textArea.select();
                try {
                    document.execCommand('copy');
                    showToast('Nomor berhasil disalin ke clipboard!');
                } catch (err) {
                    showToast('Gagal menyalin nomor');
                }
                document.body.removeChild(textArea);
            });
        }

        // Toast notification
        function showToast(message) {
            const existingToast = document.querySelector('.toast-notification');
            if (existingToast) {
                existingToast.remove();
            }

            const toast = document.createElement('div');
            toast.className = 'toast-notification';
            toast.innerHTML = `<i class="fas fa-check-circle me-2"></i>${message}`;
            document.body.appendChild(toast);

            setTimeout(() => toast.classList.add('show'), 100);
            setTimeout(() => {
                toast.classList.remove('show');
                setTimeout(() => toast.remove(), 400);
            }, 3000);
        }

        // Smooth scroll animation for elements
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Initialize animations
        document.addEventListener('DOMContentLoaded', () => {
            const animatedElements = document.querySelectorAll('.animate-fade-in');
            animatedElements.forEach(el => {
                el.style.opacity = '0';
                el.style.transform = 'translateY(30px)';
                observer.observe(el);
            });
        });

        // Add click effect to WhatsApp button
        document.querySelector('.whatsapp-btn').addEventListener('click', function(e) {
            const ripple = document.createElement('span');
            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            ripple.style.width = ripple.style.height = size + 'px';
            ripple.style.left = (e.clientX - rect.left - size / 2) + 'px';
            ripple.style.top = (e.clientY - rect.top - size / 2) + 'px';
            ripple.classList.add('ripple');
            this.appendChild(ripple);
            
            setTimeout(() => {
                ripple.remove();
            }, 600);
        });
    </script>

    <style>
        .ripple {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            transform: scale(0);
            animation: ripple-animation 0.6s linear;
            pointer-events: none;
        }

        @keyframes ripple-animation {
            to {
                transform: scale(4);
                opacity: 0;
            }
        }
    </style>
</body>
</html>