<?php
// Ensure session is started only once
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">

<style>
    /* Modern Minimalist Navbar */
    .navbar-modern {
        background: rgba(255, 255, 255, 0.98);
        backdrop-filter: blur(10px);
        border: none;
        box-shadow: 0 1px 20px rgba(0, 0, 0, 0.08);
        padding: 2rem 0 2.5rem 0;
        transition: all 0.3s ease;
        position: sticky;
        top: 0;
        z-index: 1000;
    }

    .navbar-modern .navbar-brand {
        font-family: 'Playfair Display', serif;
        font-weight: 700;
        font-size: 3rem;
        color: #1a1a1a;
        text-decoration: none;
        letter-spacing: -0.5px;
        display: flex;
        align-items: center;
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
    }

    .navbar-modern .nav-link {
        font-family: 'Playfair Display', serif;
        color: #1a1a1a !important;
        font-weight: 500;
        font-size: 0.95rem;
        padding: 0.75rem 1.2rem !important;
        margin: 0 0.2rem;
        border-radius: 8px;
        transition: all 0.3s ease;
        position: relative;
        text-decoration: none;
    }

    .navbar-modern .nav-link:hover {
        color: #667eea !important;
        background: rgba(102, 126, 234, 0.05);
        transform: translateY(-1px);
    }

    .navbar-modern .nav-link.active {
        color: #667eea !important;
        background: rgba(102, 126, 234, 0.1);
        font-weight: 600;
    }

    .navbar-modern .nav-link.active::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 20px;
        height: 2px;
        background: #667eea;
        border-radius: 1px;
    }

    /* Modern Buttons */
    .btn-modern {
        font-family: 'Playfair Display', serif;
        padding: 0.6rem 1.5rem;
        border-radius: 25px;
        font-weight: 600;
        font-size: 0.9rem;
        text-decoration: none;
        transition: all 0.3s ease;
        border: 2px solid transparent;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-modern-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }

    .btn-modern-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
        color: white;
    }

    .btn-modern-outline {
        background: transparent;
        color: #1a1a1a;
        border-color: #e1e5e9;
    }

    .btn-modern-outline:hover {
        background: #1a1a1a;
        color: white;
        border-color: #1a1a1a;
        transform: translateY(-2px);
    }

    /* Hamburger Menu */
    .hamburger-menu {
        display: flex;
        flex-direction: column;
        justify-content: space-around;
        width: 35px;
        height: 30px;
        background: transparent;
        border: none;
        cursor: pointer;
        padding: 0;
        z-index: 1001;
    }

    .hamburger-menu span {
        width: 100%;
        height: 4px;
        background: #1a1a1a;
        border-radius: 2px;
        transition: all 0.3s ease;
        transform-origin: center;
    }

    .hamburger-menu.active span:nth-child(1) {
        transform: rotate(45deg) translate(6px, 6px);
    }

    .hamburger-menu.active span:nth-child(2) {
        opacity: 0;
    }

    .hamburger-menu.active span:nth-child(3) {
        transform: rotate(-45deg) translate(6px, -6px);
    }

    /* Fullscreen Menu Overlay */
    .fullscreen-menu {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background: rgba(255, 255, 255, 0.98);
        backdrop-filter: blur(20px);
        z-index: 1000;
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        visibility: hidden;
        transition: all 0.4s ease;
    }

    .fullscreen-menu.active {
        opacity: 1;
        visibility: visible;
    }

    .fullscreen-menu-content {
        text-align: center;
        max-width: 600px;
        padding: 2rem;
    }

    .fullscreen-menu .nav-link {
        font-family: 'Playfair Display', serif;
        display: block;
        font-size: 2.5rem;
        font-weight: 600;
        color: #1a1a1a;
        text-decoration: none;
        padding: 1rem 0;
        margin: 1rem 0;
        transition: all 0.3s ease;
        position: relative;
        opacity: 0;
        transform: translateY(30px);
    }

    .fullscreen-menu.active .nav-link {
        opacity: 1;
        transform: translateY(0);
    }

    .fullscreen-menu .nav-link:nth-child(1) { transition-delay: 0.1s; }
    .fullscreen-menu .nav-link:nth-child(2) { transition-delay: 0.2s; }
    .fullscreen-menu .nav-link:nth-child(3) { transition-delay: 0.3s; }
    .fullscreen-menu .nav-link:nth-child(4) { transition-delay: 0.4s; }
    .fullscreen-menu .nav-link:nth-child(5) { transition-delay: 0.5s; }

    .fullscreen-menu .nav-link:hover {
        color: #667eea;
        transform: translateX(20px);
    }

    .fullscreen-menu .nav-link.active {
        color: #667eea;
    }

    .fullscreen-menu .nav-link i {
        margin-right: 1rem;
        font-size: 2rem;
        opacity: 0.7;
    }

    .fullscreen-menu .btn-modern {
        font-family: 'Playfair Display', serif;
        margin: 1rem 0.5rem;
        font-size: 1.1rem;
        padding: 0.8rem 2rem;
    }

    /* Close button for fullscreen menu */
    .menu-close {
        position: absolute;
        top: 2rem;
        right: 2rem;
        background: none;
        border: none;
        font-size: 2rem;
        color: #1a1a1a;
        cursor: pointer;
        transition: all 0.3s ease;
        opacity: 0;
        transform: rotate(90deg);
    }

    .fullscreen-menu.active .menu-close {
        opacity: 1;
        transform: rotate(0deg);
        transition-delay: 0.6s;
    }

    .menu-close:hover {
        color: #667eea;
        transform: scale(1.1);
    }

    /* Shopping Cart Icon */
    .cart-icon {
        position: relative;
        margin-right: 1rem;
    }

    .cart-badge {
        position: absolute;
        top: -8px;
        right: -8px;
        background: #ff6b6b;
        color: white;
        border-radius: 50%;
        width: 20px;
        height: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.7rem;
        font-weight: 700;
    }

    /* Mobile Responsive */
    @media (max-width: 991.98px) {
        .navbar-modern {
            padding: 1.2rem 0 1.8rem 0;
        }

        .navbar-modern .navbar-brand {
            font-size: 2rem;
        }

        .fullscreen-menu .nav-link {
            font-size: 2rem;
        }
    }

    @media (max-width: 576px) {
        .navbar-modern .navbar-brand {
            font-size: 1.8rem;
        }

        .fullscreen-menu .nav-link {
            font-size: 1.8rem;
        }

        .fullscreen-menu .btn-modern {
            font-size: 1rem;
            padding: 0.7rem 1.5rem;
        }

        .menu-close {
            top: 1.5rem;
            right: 1.5rem;
            font-size: 1.5rem;
        }
    }

    @media (max-width: 576px) {
        .navbar-modern .navbar-brand {
            font-size: 1.3rem;
        }

        .navbar-modern .navbar-brand img {
            height: 30px;
        }
    }

    /* Animation for navbar on scroll */
    .navbar-scrolled {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(15px);
        box-shadow: 0 2px 30px rgba(0, 0, 0, 0.1);
        padding: 0.8rem 0;
    }
</style>

<nav class="navbar navbar-expand-lg navbar-modern" id="mainNavbar">
    <div class="container position-relative">
        <!-- Hamburger Menu Button -->
        <button class="hamburger-menu" id="hamburgerMenu" aria-label="Toggle navigation">
            <span></span>
            <span></span>
            <span></span>
        </button>

        <!-- Centered Brand -->
        <a class="navbar-brand" href="/vedge/index.php">
            vedge
        </a>
    </div>
</nav>

<!-- Fullscreen Menu Overlay -->
<div class="fullscreen-menu" id="fullscreenMenu">
    <button class="menu-close" id="menuClose">
        <i class="fas fa-times"></i>
    </button>
    
    <div class="fullscreen-menu-content">
        <?php if (isset($_SESSION['user_id'])): ?>
            <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'index.php' || basename($_SERVER['PHP_SELF']) == '' ? ' active' : '' ?>" href="/vedge/index.php">
                <i class="fas fa-home"></i>Beranda
            </a>
            <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'profile.php' ? ' active' : '' ?>" href="/vedge/pelanggan/profile.php">
                <i class="fas fa-user"></i>Profil
            </a>
            <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'kontak.php' ? ' active' : '' ?>" href="/vedge/pelanggan/kontak.php">
                <i class="fas fa-envelope"></i>Kontak
            </a>
            <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'keranjang.php' ? ' active' : '' ?>" href="/vedge/pelanggan/keranjang.php">
                <i class="fas fa-shopping-cart"></i>Keranjang
            </a>
            <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'riwayat.php' ? ' active' : '' ?>" href="/vedge/pelanggan/riwayat.php">
                <i class="fas fa-history"></i>Riwayat
            </a>
            
            <div style="margin-top: 3rem;">
                <a href="/vedge/logout.php" class="btn-modern btn-modern-outline">
                    <i class="fas fa-sign-out-alt"></i>
                    Logout
                </a>
            </div>
        <?php else: ?>
            <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'index.php' || basename($_SERVER['PHP_SELF']) == '' ? ' active' : '' ?>" href="/vedge/index.php">
                <i class="fas fa-home"></i>Beranda
            </a>
            
            <div style="margin-top: 3rem;">
                <a href="/vedge/login.php" class="btn-modern btn-modern-outline me-2">
                    <i class="fas fa-sign-in-alt"></i>
                    Login
                </a>
                <a href="/vedge/register.php" class="btn-modern btn-modern-primary">
                    <i class="fas fa-user-plus"></i>
                    Register
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
    // Navbar scroll effect
    window.addEventListener('scroll', function() {
        const navbar = document.getElementById('mainNavbar');
        if (window.scrollY > 50) {
            navbar.classList.add('navbar-scrolled');
        } else {
            navbar.classList.remove('navbar-scrolled');
        }
    });

    // Fullscreen Menu Functionality
    const hamburgerMenu = document.getElementById('hamburgerMenu');
    const fullscreenMenu = document.getElementById('fullscreenMenu');
    const menuClose = document.getElementById('menuClose');
    const body = document.body;

    function openMenu() {
        hamburgerMenu.classList.add('active');
        fullscreenMenu.classList.add('active');
        body.style.overflow = 'hidden'; // Prevent background scrolling
    }

    function closeMenu() {
        hamburgerMenu.classList.remove('active');
        fullscreenMenu.classList.remove('active');
        body.style.overflow = ''; // Restore scrolling
    }

    hamburgerMenu.addEventListener('click', openMenu);
    menuClose.addEventListener('click', closeMenu);

    // Close menu when clicking on a menu item
    document.querySelectorAll('.fullscreen-menu .nav-link').forEach(link => {
        link.addEventListener('click', closeMenu);
    });

    // Close menu when pressing Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && fullscreenMenu.classList.contains('active')) {
            closeMenu();
        }
    });

    // Close menu when clicking outside (on the overlay)
    fullscreenMenu.addEventListener('click', function(e) {
        if (e.target === fullscreenMenu) {
            closeMenu();
        }
    });

    // Smooth scroll for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });


</script>