<?php
require '../config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Get transaction ID from URL parameter
$transaksi_id = isset($_GET['transaksi_id']) ? (int)$_GET['transaksi_id'] : 0;

// Get transaction details
$trx = mysqli_query($conn, "SELECT * FROM transaksi WHERE id = $transaksi_id AND pengguna_id = $user_id AND status = 'menunggu'");
$transaksi = mysqli_fetch_assoc($trx);

if (!$transaksi) {
    header("Location: riwayat.php?error=no_transaction");
    exit;
}

// Data bank untuk ditampilkan
$rekeningInfo = [
    'mandiri' => [
        'nama' => 'Bank Mandiri',
        'no' => '137-00-9876543-1',
        'an' => 'Nando',
        'logo' => '../assets/mandiri.png'
    ],
    'bca' => [
        'nama' => 'Bank BCA',
        'no' => '7391516859',
        'an' => 'Nando',
        'logo' => '../assets/bca.png'
    ],
    'bri' => [
        'nama' => 'Bank BRI',
        'no' => '0987654321',
        'an' => 'Nando',
        'logo' => '../assets/bri.png'
    ],
    'gopay' => [
        'nama' => 'GoPay',
        'no' => '081314215856',
        'an' => 'Nando',
        'logo' => '../assets/gopay.png'
    ]
];

$bank = $rekeningInfo[$transaksi['metode_pembayaran']] ?? null;

// Proses upload bukti pembayaran
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['bukti_pembayaran']) && $_FILES['bukti_pembayaran']['error'] === UPLOAD_ERR_OK) {
        $allowed_types = ['image/jpeg', 'image/jpg', 'image/png'];
        $file_type = $_FILES['bukti_pembayaran']['type'];

        if (in_array($file_type, $allowed_types)) {
            $file_extension = pathinfo($_FILES['bukti_pembayaran']['name'], PATHINFO_EXTENSION);
            $new_filename = uniqid() . '_' . basename($_FILES['bukti_pembayaran']['name']);
            $upload_path = '../upload/' . $new_filename;

            if (move_uploaded_file($_FILES['bukti_pembayaran']['tmp_name'], $upload_path)) {
                // Update transaksi dengan bukti pembayaran
                $query = "UPDATE transaksi SET bukti_pembayaran = ?, status = 'dibayar' WHERE id = ?";
                $stmt = $conn->prepare($query);
                $stmt->bind_param("si", $new_filename, $transaksi['id']);

                if ($stmt->execute()) {
                    // Set session untuk menampilkan info rekening di riwayat
                    $_SESSION['payment_success'] = [
                        'bank_info' => $bank,
                        'transaction_id' => $transaksi['id'],
                        'total' => $transaksi['total_harga']
                    ];

                    header("Location: riwayat.php?payment_success=1");
                    exit;
                } else {
                    $error = "Gagal menyimpan bukti pembayaran. Silakan coba lagi.";
                }
            } else {
                $error = "Gagal mengupload file. Silakan coba lagi.";
            }
        } else {
            $error = "Format file tidak didukung. Gunakan JPG, JPEG, atau PNG.";
        }
    } else {
        $error = "Silakan pilih file bukti pembayaran.";
    }
}

// Get transaction details/items (after potential redirect)
$detail_query = "
    SELECT td.*, p.nama, p.gambar, up.ukuran 
    FROM transaksi_detail td
    JOIN produk p ON td.produk_id = p.id
    JOIN ukuran_produk up ON td.ukuran_id = up.id
    WHERE td.transaksi_id = $transaksi_id
";
$detail_result = mysqli_query($conn, $detail_query);
$detail_items = [];
while ($item = mysqli_fetch_assoc($detail_result)) {
    $detail_items[] = $item;
}

function formatKodeTransaksi($id, $tanggal)
{
    return 'TRX-' . date('Ymd', strtotime($tanggal)) . '-' . str_pad($id, 4, '0', STR_PAD_LEFT);
}

// Include navbar after all processing is complete
require '../pelanggan/navbar.php';
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Bukti Pembayaran - vedge</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Playfair Display', serif;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            min-height: 100vh;
            color: #1a1a1a;
            line-height: 1.6;
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem 1rem;
        }

        .page-header {
            text-align: center;
            margin-bottom: 3rem;
            position: relative;
        }

        .page-title {
            font-size: 3rem;
            font-weight: 700;
            color: #1a1a1a;
            margin-bottom: 0.5rem;
            letter-spacing: -0.02em;
        }

        .page-subtitle {
            font-size: 1.1rem;
            color: #666;
            font-weight: 400;
            font-style: italic;
        }

        .page-title::after {
            content: '';
            position: absolute;
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 2px;
            background: #1a1a1a;
        }

        .content-grid {
            display: grid;
            grid-template-columns: 1fr 400px;
            gap: 2rem;
            margin-top: 2rem;
        }

        .card {
            background: rgba(255, 255, 255, 0.95);
            border: none;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.12);
        }

        .card-header {
            background: #1a1a1a;
            color: white;
            border: none;
            padding: 1.5rem 2rem;
            font-weight: 600;
            font-size: 1.1rem;
            letter-spacing: 0.5px;
        }

        .card-body {
            padding: 2rem;
        }

        .transaction-table {
            width: 100%;
            border-collapse: collapse;
        }

        .transaction-table th {
            background: #f8f9fa;
            color: #1a1a1a;
            font-weight: 600;
            padding: 1rem;
            text-align: left;
            border-bottom: 2px solid #e9ecef;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .transaction-table td {
            padding: 1.5rem 1rem;
            border-bottom: 1px solid #f1f3f4;
            vertical-align: middle;
        }

        .transaction-table tr:hover {
            background: rgba(26, 26, 26, 0.02);
        }

        .product-info {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .product-name {
            font-weight: 600;
            color: #1a1a1a;
            font-size: 1rem;
        }

        .badge {
            background: #1a1a1a;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 25px;
            font-size: 0.8rem;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-right: 0.5rem;
        }

        .price {
            font-weight: 700;
            color: #1a1a1a;
            font-size: 1.1rem;
        }

        .total-row {
            background: #1a1a1a !important;
            color: white !important;
        }

        .total-row th,
        .total-row td {
            color: white !important;
            font-weight: 700;
            font-size: 1.1rem;
        }

        .bank-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 15px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            border: 1px solid #e9ecef;
        }

        .bank-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .bank-logo {
            width: 50px;
            height: 35px;
            object-fit: contain;
            border-radius: 8px;
        }

        .bank-name {
            font-weight: 600;
            color: #1a1a1a;
            margin: 0;
        }

        .bank-method {
            color: #666;
            font-size: 0.9rem;
            font-style: italic;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            font-weight: 600;
            color: #1a1a1a;
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 1rem;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: white;
            color: #1a1a1a;
        }

        .form-control:focus {
            border-color: #1a1a1a;
            box-shadow: 0 0 0 3px rgba(26, 26, 26, 0.1);
            outline: none;
        }

        .input-group {
            display: flex;
            gap: 0.5rem;
        }

        .btn {
            border-radius: 12px;
            padding: 1rem 2rem;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border: none;
            cursor: pointer;
        }

        .btn-primary {
            background: #1a1a1a;
            color: white;
        }

        .btn-primary:hover {
            background: #000;
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(26, 26, 26, 0.3);
        }

        .btn-outline {
            background: transparent;
            color: #1a1a1a;
            border: 2px solid #1a1a1a;
        }

        .btn-outline:hover {
            background: #1a1a1a;
            color: white;
            transform: translateY(-2px);
        }

        .btn-copy {
            background: #1a1a1a;
            color: white;
            padding: 0.75rem 1rem;
            border-radius: 8px;
            font-size: 0.9rem;
        }

        .btn-copy:hover {
            background: #000;
        }

        .alert {
            border-radius: 12px;
            padding: 1rem 1.5rem;
            margin-bottom: 2rem;
            border: none;
        }

        .alert-danger {
            background: #fee;
            color: #c53030;
            border-left: 4px solid #c53030;
        }

        .file-input-wrapper {
            position: relative;
            display: inline-block;
            width: 100%;
        }

        .file-input {
            opacity: 0;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }

        .file-input-label {
            display: block;
            padding: 1.5rem;
            border: 2px dashed #e9ecef;
            border-radius: 12px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }

        .file-input-label:hover {
            border-color: #1a1a1a;
            background: #f1f3f4;
        }

        .file-input-label i {
            font-size: 2rem;
            color: #666;
            margin-bottom: 0.5rem;
        }

        .file-text {
            font-weight: 600;
            color: #1a1a1a;
            margin-bottom: 0.25rem;
        }

        .file-hint {
            color: #666;
            font-size: 0.9rem;
        }

        .fade-in {
            animation: fadeIn 0.8s ease-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .content-grid {
                grid-template-columns: 1fr;
                gap: 1.5rem;
            }
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem 0.5rem;
            }

            .page-title {
                font-size: 2.5rem;
            }

            .page-subtitle {
                font-size: 1rem;
            }

            .card-body {
                padding: 1.5rem;
            }

            .transaction-table th,
            .transaction-table td {
                padding: 1rem 0.5rem;
                font-size: 0.9rem;
            }

            .product-info {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.5rem;
            }

            .btn {
                padding: 0.875rem 1.5rem;
                font-size: 0.9rem;
            }
        }

        @media (max-width: 480px) {
            .page-title {
                font-size: 2rem;
            }

            .card-header {
                padding: 1rem 1.5rem;
                font-size: 1rem;
            }

            .card-body {
                padding: 1rem;
            }

            .transaction-table {
                font-size: 0.85rem;
            }

            .bank-header {
                flex-direction: column;
                text-align: center;
                gap: 0.5rem;
            }
        }
    </style>
</head>

<body>
    <div class="main-container fade-in">
        <div class="page-header">
            <h1 class="page-title">Upload Bukti Pembayaran</h1>
            <p class="page-subtitle">Complete your payment by uploading proof of transfer</p>
        </div>

        <?php if (isset($error)): ?>
            <div class="alert alert-danger" role="alert">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <?= htmlspecialchars($error) ?>
            </div>
        <?php endif; ?>

        <div class="content-grid">
            <!-- Transaction Details -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-receipt me-2"></i>
                    Transaction #<?= formatKodeTransaksi($transaksi['id'], $transaksi['dibuat_pada']) ?>
                </div>
                <div class="card-body">
                    <table class="transaction-table">
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th>Details</th>
                                <th>Price</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($detail_items as $item): ?>
                                <tr>
                                    <td>
                                        <div class="product-info">
                                            <i class="fas fa-tshirt" style="color: #1a1a1a;"></i>
                                            <span class="product-name"><?= htmlspecialchars($item['nama']) ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge"><?= htmlspecialchars($item['ukuran']) ?></span>
                                        <span class="badge">Qty: <?= $item['jumlah'] ?></span>
                                    </td>
                                    <td class="price">Rp<?= number_format($item['subtotal']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" style="text-align: right; font-weight: 600;">Shipping Cost</td>
                                <td class="price">Rp<?= number_format($transaksi['ongkos_kirim']) ?></td>
                            </tr>
                            <tr class="total-row">
                                <td colspan="2" style="text-align: right;">Total Payment</td>
                                <td>Rp<?= number_format($transaksi['total_harga']) ?></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <!-- Payment Information & Upload -->
            <div class="payment-section">
                <!-- Bank Information -->
                <?php if ($bank): ?>
                    <div class="card">
                        <div class="card-header">
                            <i class="fas fa-credit-card me-2"></i>
                            Payment Information
                        </div>
                        <div class="card-body">
                            <div class="bank-section">
                                <div class="bank-header">
                                    <img src="<?= $bank['logo'] ?>" alt="<?= $bank['nama'] ?>" class="bank-logo">
                                    <div>
                                        <h6 class="bank-name"><?= $bank['nama'] ?></h6>
                                        <p class="bank-method">Payment Method</p>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="form-label">Account Number</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" value="<?= $bank['no'] ?>" readonly>
                                        <button class="btn btn-copy" type="button" onclick="copyToClipboard('<?= $bank['no'] ?>')">
                                            <i class="fas fa-copy"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="form-label">Account Holder</label>
                                    <input type="text" class="form-control" value="<?= $bank['an'] ?>" readonly>
                                </div>

                                <div class="form-group">
                                    <label class="form-label">Transfer Amount</label>
                                    <input type="text" class="form-control" value="Rp<?= number_format($transaksi['total_harga']) ?>" readonly style="font-weight: 700; font-size: 1.1rem;">
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Upload Form -->
                <div class="card">
                    <div class="card-header">
                        <i class="fas fa-upload me-2"></i>
                        Upload Proof of Payment
                    </div>
                    <div class="card-body">
                        <form method="POST" enctype="multipart/form-data">
                            <div class="form-group">
                                <div class="file-input-wrapper">
                                    <input type="file" class="file-input" id="bukti_pembayaran" name="bukti_pembayaran" accept="image/*" required>
                                    <label for="bukti_pembayaran" class="file-input-label">
                                        <i class="fas fa-cloud-upload-alt"></i>
                                        <div class="file-text">Choose File</div>
                                        <div class="file-hint">JPG, PNG, JPEG (Max 5MB)</div>
                                    </label>
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-upload me-2"></i>
                                    Upload & Complete Payment
                                </button>
                            </div>

                            <div class="form-group">
                                <a href="riwayat.php" class="btn btn-outline w-100">
                                    <i class="fas fa-arrow-left me-2"></i>
                                    Back to History
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                // Create a temporary notification
                const notification = document.createElement('div');
                notification.style.cssText = `
                    position: fixed;
                    top: 20px;
                    right: 20px;
                    background: #1a1a1a;
                    color: white;
                    padding: 1rem 1.5rem;
                    border-radius: 8px;
                    font-family: 'Playfair Display', serif;
                    font-weight: 600;
                    z-index: 1000;
                    transform: translateX(100%);
                    transition: transform 0.3s ease;
                `;
                notification.textContent = 'Account number copied!';
                document.body.appendChild(notification);

                setTimeout(() => {
                    notification.style.transform = 'translateX(0)';
                }, 100);

                setTimeout(() => {
                    notification.style.transform = 'translateX(100%)';
                    setTimeout(() => notification.remove(), 300);
                }, 2000);
            }).catch(function(err) {
                console.error('Could not copy text: ', err);
            });
        }

        // File input preview
        document.getElementById('bukti_pembayaran').addEventListener('change', function(e) {
            const file = e.target.files[0];
            const label = document.querySelector('.file-input-label');
            
            if (file) {
                label.innerHTML = `
                    <i class="fas fa-check-circle" style="color: #28a745;"></i>
                    <div class="file-text">${file.name}</div>
                    <div class="file-hint">File selected successfully</div>
                `;
            }
        });
    </script>
</body>

</html>