<?php
require '../config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$transaksi_id = $_POST['transaksi_id'] ?? null;

if (!$transaksi_id || !filter_var($transaksi_id, FILTER_VALIDATE_INT)) {
    echo "<script>alert('ID transaksi tidak valid.'); window.history.back();</script>";
    exit;
}

// Verifikasi bahwa transaksi milik user yang login
$stmt = $conn->prepare("SELECT id, status FROM transaksi WHERE id = ? AND pengguna_id = ?");
$stmt->bind_param("ii", $transaksi_id, $user_id);
$stmt->execute();
$result = $stmt->get_result();
$transaksi = $result->fetch_assoc();

if (!$transaksi) {
    echo "<script>alert('Transaksi tidak ditemukan atau bukan milik Anda.'); window.history.back();</script>";
    exit;
}

// Cek apakah status transaksi adalah 'dikirim'
if ($transaksi['status'] !== 'dikirim') {
    echo "<script>alert('Hanya pesanan dengan status Sedang Dikirim yang bisa diselesaikan.'); window.history.back();</script>";
    exit;
}

// Update status transaksi menjadi 'selesai' dan set tanggal selesai
$stmt_update = $conn->prepare("UPDATE transaksi SET status = 'selesai', tanggal_selesai = NOW() WHERE id = ?");
$stmt_update->bind_param("i", $transaksi_id);

if ($stmt_update->execute()) {
    echo "<script>
        alert('Pesanan berhasil ditandai sebagai selesai. Terima kasih!');
        window.location.href = '../pelanggan/riwayat.php';
    </script>";
} else {
    echo "<script>
        alert('Gagal memperbarui status pesanan. Silakan coba lagi.');
        window.history.back();
    </script>";
}

$stmt->close();
$stmt_update->close();
$conn->close();
