<?php
require '../config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
  header("Location: ../login.php");
  exit;
}

$id = $_SESSION['user_id'];

$nama = $_POST['nama'] ?? '';
$email = $_POST['email'] ?? '';
$jenis_kelamin = $_POST['jenis_kelamin'] ?? '';
$no_telp = $_POST['no_telp'] ?? '';
$provinsi = $_POST['provinsi'] ?? '';
$kabupaten = $_POST['kabupaten'] ?? '';
$kecamatan = $_POST['kecamatan'] ?? '';
$kelurahan = $_POST['kelurahan'] ?? '';
$alamat_lengkap = $_POST['alamat_lengkap'] ?? '';

// Validasi input required fields dengan nama yang sesuai
$required_fields = [
  'nama' => 'Nama Lengkap',
  'email' => 'Email',
  'jenis_kelamin' => 'Jenis Kelamin',
  'provinsi' => 'Provinsi',
  'kabupaten' => 'Kabupaten/Kota',
  'kecamatan' => 'Kecamatan',
  'kelurahan' => 'Kelurahan'
];

$missing_fields = [];

foreach ($required_fields as $field => $label) {
  if (empty($_POST[$field])) {
    $missing_fields[] = $label;
  }
}

if (!empty($missing_fields)) {
  echo "<script>alert('Field berikut harus diisi: " . implode(', ', $missing_fields) . "'); window.history.back();</script>";
  exit;
}

// Validasi email format
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  echo "<script>alert('Format email tidak valid!'); window.history.back();</script>";
  exit;
}

// Cek apakah email sudah digunakan pengguna lain
$stmt = $conn->prepare("SELECT id FROM pengguna WHERE email = ? AND id != ?");
$stmt->bind_param("si", $email, $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
  echo "<script>alert('Email sudah digunakan oleh pengguna lain!'); window.history.back();</script>";
  exit;
}

// Update profil dengan prepared statement
$stmt = $conn->prepare("UPDATE pengguna SET 
  nama = ?,
  email = ?,
  jenis_kelamin = ?,
  no_telp = ?,
  provinsi = ?,
  kabupaten_kota = ?,
  kecamatan = ?,
  kelurahan = ?,
  alamat_lengkap = ?
  WHERE id = ?");

$stmt->bind_param("sssssssssi", $nama, $email, $jenis_kelamin, $no_telp, $provinsi, $kabupaten, $kecamatan, $kelurahan, $alamat_lengkap, $id);

if ($stmt->execute()) {
  echo "<script>alert('Profil berhasil diperbarui!'); window.location='../pelanggan/profile.php';</script>";
} else {
  echo "<script>alert('Gagal memperbarui profil. Silakan coba lagi.'); window.history.back();</script>";
}

$stmt->close();
$conn->close();
